.H 1 "Process Window"
The Process window is the focal point for examining a
process or core dump.
The window displays the current status of the program,
and when the program is stopped, a list of all the activation
records (stack frames) on the stack.
The menus can be used to open all the other windows associated with
the process, and to control the process at the statement level.
.H 2 "Process Layout"
The title bar identifies the window as a Process window and
displays the process id number or name of the core file.
The first line in the window lists the current status of the process
along with the current value of the program counter (pc).
.P
The pc is displayed in one of two formats.
If the pc points to a routine that pi has symbolic source
file and line information for (the function was compiled with the -g option),
the file and line number are displayed as shown below.
.DS I N
file:linenumber+offset
.DE
.P
The offset is the difference in bytes between the current
pc and the address of the first instruction implementing the line number.
If symbolic information is not available for the function,
or the pc is in a function prologue, the name of the function will be used in
place of the file name and line number.
.DS I N
function()+offset
.DE
.P
Here the offset is the difference in bytes between the pc
the starting address of the function.
These address formats are also used in the Assembler window,
Frame window title bars, and the Breakpoint window.
.P
The possible status lines and their meanings are listed below:
.VL 7 1
.LI "RUNNING: pc=address"
.br
The program is currently executing.
While a process is running, pi updates the status line
by polling the process once a second.
.LI "STOPPED: pc=address"
.br
The process has stopped from a SIGSTOP signal,
usually from selecting the "stop" entry in the "stmt" menu.
.LI "BREAKPOINT:"
.br
The process is stopped at a breakpoint.
When a breakpoint is hit pi selects the
source statement in a Source Text window or assembler instruction
in the Assembler window where the breakpoint was set.
.LI "STMT STEPPED: pc=address"
.br
The process has stopped after stepping a statement.
.LI "INSTR STEPPED: pc=address"
.br
The process has stopped after stepping an assembler instruction.
.LI "EVENT PENDING: bus error"
.br
The process stopped because a signal was received.
The exact message depends on the signal.
Signals sent to the process are intercepted by the debugger, which allows you 
to either cancel the signal, or send it on to the process.
To send the signal, just resume executing the process.
To cancel it, use the menu bar in the Signals window.
The Signals window allows you to choose which signals are
intercepted by the debugger.
This status line is displayed when core dumps are examined.
.LI "ERROR STATE: exited with status 9"
.br
The process exited or died from a signal.
No further debugging may be performed on the process.
.LI "step N statements|instructions"
.br
The process is being stepped a large number of statements or instructions.
N is the number of remaining steps and will count down.
.LE
.P
The second line in the window is for error messages.
For example, when program is started from the debugger with the
"hang & open proc" menu entry in the Unix Pi window,
the first two lines in the Process window initially are:
.DS I N
STOPPED: pc=start()
cannot obtain callstack
.DE
.P
indicating that no activation records were found.
Until the program executes the first subroutine call,
there are no activation records on the stack.
In normal operation the second line in the window is blank.
.P
If the process is stopped, line 3 and below list the activation
records on the stack, one per line, from the most recently called
function to the oldest.
Unless you use a special start-off file,
the activation record on the bottom line of the Process window is 
a call to main().
.P
Each activation record lists the symbolic value of the pc,
the function name, and any arguments (parameters).
Activation records for functions compiled with the -g option
have the following format:
.DS I N
file:linenumber+offset function(arg=value ... )
.DE
.P
The number of arguments, as well as their names and type
depends on the function's declarations.
Functions for which symbolic information is not available
are displayed in the following format:
.DS I N
function+offset function()
.DE
.P
The list of activation records is updated every time the process stops,
although when stepping multiple statements or instructions,
the list is not updated until after the last step.
The Process window limits the display to the top 1000 activation records,
which should be adequate for all but the deepest recursive functions.
.H 2 "Process Menu Bar"
The menu bar contains the "views" and "stmt" menus, along with a "kill"
button.
The "views" menu allows the other windows associated with the process to
be opened and contains the following entries:
.VL 13 1
.LI "Source"
Open the Source Files window for the program.
The Source Files window lists the files compiled with the -g option
that were used to construct the program.
If the program was constructed from a single source file, this entry 
opens the Source Text window for that file directly.
.LI "Globals"
Open the Globals window, a Frame window that accesses global variables. 
The menu bar in the Globals window lists all the global variables.
.LI "Memory"
Open the Memory window, allowing memory to be examined as a sequence of cells.
.LI "Assembler"
Open the Assembler window.
Used to debug assembly code and examine the
instructions generated by the compiler.
.LI "User Types"
Open the User Types window.
Used to view the declarations for the program's structs and unions
and to set the default fields and 
formats that are displayed when instances of these types are examined.
.LI "Journal"
Open the Journal window.
This window keeps a log of recent changes in the state of the process.
.LI "Signals"
Open the Signals window.
Used to send signals to the process and intercept signals sent to the process.
.LI "Breakpoints"
Open the Breakpoint window.
.LE
.P
The "stmt" menu controls the process
at the source code statement level and contains the following entries.
When debugging source code, it is recommended that the
pushpin in the "stmt" menu be placed in the hole,
so the menu remains visible on the screen.
.VL 11 1
.LI "run"
Run continues a suspended application.
The application will continue running until one of the following happens:
.AL 1
.LI
A breakpoint is hit.
.LI
A conditional breakpoint is hit and the condition is true.
.LI
A tracepoint or conditional breakpoint is hit and the value
of a spy expression changes.
.LI
A "stop" request is sent.
.LI
The application receives a signal that is being traced.
.LI
An error occurs.
.LI
The application exits.
.LE
.P
While running, pi polls the program once a second to determine
its status and to evaluate any spy expressions.
.LI "stop"
Stop suspends a running application by sending the Unix signal SIGSTOP.
The stop operator does not wait for the process to stop,
but pi will notice the arrival of SIGSTOP the next time it checks
the status of the program.
.LI "current"
Open the Source Text window and select the source line corresponding
to the current program counter.
.LI "return"
Run the process at full speed until the top
activation record on the stack returns.
When the process stops, the source line corresponding to the new
program counter is selected.
If the attempt to return takes more than 15 seconds to
execute (usually because a function call is 
complicated or blocks in a system call), pi will stop the process.
.LI "step into"
By default, stepping a statement steps over any function calls.
This entry causes pi to step into any functions it
encounters in the statement.
When you step into a function for which pi has symbolic debugging information,
pi opens the Source Text window for the file containing that function,
and selects the function's first source line.
If after getting into a function you decide you really didn't
want to step into it, you may get out of the function
with the "return" operator.
.LI "step N"
Single step the process N statements, stepping over any function calls.
Before the process is stepped, all the breakpoints are temporarily removed.
After each step, the number of remaining statements is
printed in the Process window and any spy expressions are evaluated.
If any of the spy expressions change value, pi stops stepping.
When the stepping is finished, the source line corresponding to the new
program counter is selected.
If you attempt to step over a statement that takes more
than 15 seconds to execute (usually because a function call is 
complicated or blocks in a system call), pi will stop the process.
.LE
.P
Stepping large numbers of statements is useful
when used in combination with spy expressions (see "Spies").
For example, if you don't know which statement is changing a
memory location's value, you can make the memory location a spy and
step a large number of statements.
Pi will stop at the first statement after the value of the memory location
changes.
.P
The "return" entry is useful if you step into a function with 
"step into" and then decide after getting into the function,
that you really didn't want to.
For example, suppose you want to step into the function f()
in the following C statement:
.DS I N
f(g());
.DE
.P
If you choose "step into" you will first step into the function g(),
as it is the first function encountered in the statement.
After stepping into g(), you can step out of g() and into f() by:
.AL 1
.LI
Selecting "return" to get out of g().
.LI
Reselecting "step into" to step into f().
.LE
.P
This sequence is much simpler than other alternatives,
such as setting a breakpoint at the end of g() and removing
it after hitting it, or setting and removing a breakpoint before
the call to f() in the Assembler window.
.P
The "kill" button kills the process by sending it the Unix signal SIGKILL.
Since this operation is irrevocable, pi will ask you to confirm this
selection with a pop-up window.
.P
If a Process window is closed, either by selecting "close" in the "edit"
menu or using the window manager, pi disconnects the
debugger from the process and closes
all other windows associated with it.
The process is left in the state it was in at the time of the 
closing, i.e. running programs continue executing and
programs suspended at a breakpoint or stopped,
are disconnected in the suspended state.
.P
When a Process window is created errors may occur that prevent pi
from completing the initialization procedure.
In these cases, the Process window contains an error message and
the menu bar contain entries that allow you to complete
the initialization.
For example, when attaching to programs started outside of the debugger under 
SunOS, pi may successfully attach to the process with ptrace,
but not be able to open the file containing the symbol table
because it is not in the current directory or in one of 
the directories on your PATH.
If this happens, the second line in the Process window 
contains the error message:
.DS I N
symbol tables: No such file or directory
.DE
.P
and the menu bar contains the single entry, "open process".
At this point you have the option to fix the problem by changing
the current directory from the Directory window and
continuing the initialization from the menu, or disconnect the 
debugger from the process by closing the Process window.
.H 2 "Process Keyboard"
Syntax
.DS I N
function {|}|{} [condition]
file:linenumber [condition]
.DE
.P
The keyboard language allows you to set breakpoints
or conditional breakpoints in a function by typing its name,
or at a line in a source file.
The function format allows you to set a breakpoint at a function's prologue,
epilogue, or both. 
For example, if x() is a C function, the input string:
.DS I N
x{
.DE
.P
is equivalent to opening the Source Text window for the file containing x(),
and placing a breakpoint at the first `{' after x()'s argument declarations.
Similarly:
.DS I N
x}
.DE
.P
places a breakpoint at x()'s closing `}' and:
.DS I N
x{}
.DE
.P
places a breakpoint at the starting `{' and closing `}'.
If the optional condition is present the breakpoint becomes a
conditional breakpoint, and condition is the C expression evaluated.
If condition is 0, the breakpoint becomes a tracepoint.
See "Source Text Line Menus" for more on breakpoints, tracepoints,
and conditional breakpoints.
.P
The file:linenumber format sets a breakpoint at the line number
in the specified file.
.P
The keyboard language of the Process window is used infrequently,
as the function format only allows breakpoints to be set at the
function prologues and epilogues, and the
file format requires that you know line numbers.
If you know the name of the file it is easier to open the Source Text window,
scroll to the line of interest,
and place a breakpoint with the line menu,
than to try to remember line numbers.
However, there are two circumstances that make the keyboard language useful.
.P
The "function {" format can be used if you want to see the source
code of a function that isn't listed in the activation records and
you don't know what file the function is in.
For example, suppose you want to look at the source for 
function x().
If you type "x{" pi opens the Source Text window for the file containing x(),
displays the function x, and places the breakpoint in the prologue.
If you really didn't want the breakpoint, you can remove it 
with the line menu in the Source Text window.	
.P
The file:linenumber format is intended to load a set of
breakpoints from a file generated by dumping the contents of a
Breakpoint window.
This is useful if you set up a complicated set of breakpoints and
want to save them for future use, or want to debug
another instance of the same program concurrently, with the same breakpoints.
The Process window's file:linenumber input syntax is the same as
the Breakpoint window's display format.
You may save the current set of breakpoints in a file by
opening the Breakpoint window and dumping the windows
contents with the keyboard command:
.DS I N
>cat > bkptfile
.DE
.P
To use bkptfile as the keyboard input to the Process window,
place the keyboard focus in the Process window and type:
.DS I N
<cat bkptfile
.DE
.P
However, since breakpoints placed using this technique are based
on line numbers, beware that editing the source files
between the time the breakpoint list is saved and
read back in may cause the breakpoints to move.
.H 2 "Process Line Menus"
The line menu for each activation record allows you to open the
Frame window and to see the source code associated with the record.
.VL 10 1
.LI "open function() frame"
.br
Open the Frame window for the activation record.
From the Frame window you can examine the function's arguments
and local variables.
.LI "show file:linenumber"
.br
Open the Source Text window for the activation record and select
the current source line, linenumber.
This entry only appear in the menu if symbolic line and file
information is available for the function.
.LI "return"	
This entry only appear in the menu for the
top activation record in the window (most recent) and runs the process,
at full speed, until the top activation record is no longer 
on the stack.
It is equivalent to "return" in the "stmt" menu in the Process window's
menu bar.
It is not in the menu when core dumps are examined.
.LE
